-----------------------------------------------------------------
--   C++ 
-----------------------------------------------------------------
function startDlg(dialog, who, with_who)
	log("proxy", who, "  ", with_who, " ", dialog)
	if(isValid(Humans[with_who])) then
		stop(with_who)
	end
	if(isValid(Humans[who])) then
		stop(who)
	end
	hideRemark(with_who)	
	hideRemark(who)
	hideRemark()
	startDialog(dialog, who, with_who)
end
--
function sound2D(sound)
	log("sound_player", sound)
	if (isValid(sound)) then
		playSound("misc", sound, 0, 0, 0, 1)
	else
		log("sound_player", "empty sound")
	end
end
--
function getMercSquad(merc)
	log("campaign_proxy", "getMercSquad", merc)
	return (getSquad(merc))
end

function getParameter(merc, par, str_bool)
	log("campaign_proxy", "getParameter", merc, par)
	if (str_bool == true) then
		return getPersonParameterStr(merc, par)
	else
		return getPersonParameter(merc, par)
	end
end

function setParameter(merc, par, val)
	log("campaign_proxy", "setParameter", merc, par, val)
	setPersonParameter(merc, par, val)
end

function getAssignment(merc)
	log("campaign_proxy", "getAssignment", merc)
	return getPersonAssignment(merc)
end

function showComments(merc, comment, where, priority, sequence, time_out)
	
	if (not(isValid(merc)) or not(isValid(comment))) then
		log("error", "showComment: wrong arguments", merc, comment)
		return
	end
	
	if (getPersonParameter(merc, "HEALTH") < 16) then
		log("error", "ShowComment: dying mercs don't say a thing")
		return
	end
	
	if (not(isValid(where))) then
		where = table_values.corner
	end
	
	if (not(isValid(priority))) then 
		priority = 0
	end
	
	if (not(isValid(sequence))) then
		sequence = 0
	end
	
	if (not(isValid(time_out))) then
		time_out = 0
	end
	
	if (Mercs[merc] ~= nil) then
		if (Mercs[merc].hired == false) then
			where = table_values.over_head
		end
	end
	
	if (isValid(CUR_MISSION.Name)) then
		hideRemark(merc)
		showRemark(merc, comment, where, priority, sequence, time_out)
	else
		hideRemark()
		showComment(merc, comment)
	end
	
end
--
function showMessageBox(message, buttons, size)
	return messageBox(message, buttons, size)
end
--
function spawnHuman(player, person)
	if ( (player ~= nil) and (person ~= nil) ) then
		spawn(player, person)
		if ( type(CUR_MISSION.Units[player]) ~= "table" ) then
			CUR_MISSION.Units[player] = {}
		end
		table.insert(CUR_MISSION.Units[player], person)
		log("spawns", CUR_MISSION.Name, "SpawnHuman", player, person)
	end
end
--
function disappearHuman(person)
	if (IsAlive(person)) then
		disappear(person)
		log("spawns", CUR_MISSION.Name, "DisappearHuman", person)
		Sectors[CUR_MISSION.Name].onUpdate()
	else
		log("spawns", CUR_MISSION.Name, "DisappearHuman", person, "is dead and can't disapear")
	end
end
--
function spawnPersons(player, spawn_id, id, num)
	local ids = {}
	log("spawns", CUR_MISSION.Name, "SpawnPersons", player, spawn_id, id,num)
	for count = 1, num, 1 do
		local prs = Spawn[id]
		local idd = id.."_"..prs.sysname.."_"..Spawn.spawned.."_"..count
		spawnPerson(player, spawn_id, idd, prs.sysname, prs.behavior, prs.behavior_arg, prs.specialization, prs.dialog, prs.things, prs.pose)
		table.insert(CUR_MISSION.Units[player], idd)
		table.insert(ids, idd)
	end
	Spawn.spawned = Spawn.spawned + 1
	return ids
end
--
function spawnUnit(player, spawn_id, unit)
	log("spawnUnit", player, spawn_id, unit.id, unit.sysname)
	spawnPerson(player, spawn_id, unit.id, unit.sysname, unit.behavior, unit.behavior_arg, unit.specialization, unit.dialog, unit.things, unit.pose)
	table.insert(CUR_MISSION.Units[player], unit.id)
end
--
function spawnEntity(player, spawn_id, entity, suffix)
	if (suffix == nil) then
		suffix = ""
	end
	local id = spawn_id.."_"..entity.sysname..suffix
	log("spawnDefenders", id)
	spawnPerson(player, spawn_id, id, entity.sysname, entity.behavior, entity.behavior_arg, entity.specialization, entity.dialog, entity.things, entity.pose)
	table.insert(CUR_MISSION.Units[player], id)
end
--
function spawnDefenders(sector, player, num, mode)
	
	if ( not(isValid(mode)) or (mode == false) ) then
		mode = "defenders"
	elseif ( mode == true ) then
		mode = "militia"
	end

	if (not(isValid(sector)) or not(isValid(player))) then
		log("spawnDefenders", "error", "sector:", sector, "player:", player)
		return
	end

	log("spawnDefenders", "sector:", sector, "player:", player, "mode:", mode)
	
	if not(isValid(num)) then
		num = 0
		log("spawnDefenders", "num:", num)
	end
	
	local player_to_spawn = player
	
	if (mode == "militia") then
		player_to_spawn = Sectors[sector].owner
	end

	local spawns = deepcopy(SpawnAreas[sector][player_to_spawn])
	local sniper_pos = spawns.Sniper
	local guard_pos = spawns.Guard
	local soldier_pos = spawns.Soldier
	local leader_pos = spawns.Leader
	local snipers = service.getListSize(sniper_pos)
	local guards = service.getListSize(guard_pos)
	local leaders = service.getListSize(leader_pos)
	local soldiers = service.getListSize(soldier_pos)
	local snipers_num = snipers
	local guards_num = guards
	local leaders_num = leaders
	local soldiers_num = soldiers
	local total_pos = guards_num + soldiers_num
	
	if (total_pos == 0) then
		log("spawnDefenders", "no spawns")
		return
	end
	
	if (leaders > 0) then
		-- if there are leader positions - add 1 leader
		total_pos = total_pos + 1
		leaders_num = 1
	end
	
	if (snipers > 2) then
		-- if there are more than 2 sniper positions - add 3 snipers
		total_pos = total_pos + 3
		snipers_num = 3
	elseif (snipers > 0) then
		-- else if there are less than 3 sniper positions - add 1 sniper
		total_pos = total_pos + 1
		snipers_num = 1
	end

	if (mode ~= "defenders") then
		total_pos = num
		guards_num = 0
		leaders_num = 1		
		
		if (num == 5) then
			snipers_num = 1
			soldiers_num = 3
		elseif (num < 5) then
			snipers_num = 0
			soldiers_num = num - 1
		else
			snipers_num = math.floor(num / 5)
			soldiers_num = num - leaders_num - snipers_num
		end
	end
	
	if (num > total_pos) then
		-- if number of units to spawn is greater than available positions - lower the number of units to be equal to total positions
		log("spawnDefenders", num, ">", total_pos)
		num = total_pos
	end
	
	if (num == 0) then
		-- if number of units to spawn was not specified - fill all positions
		num = total_pos
	end
	
	log("spawnDefenders", "num:", num)
	
	if (num < total_pos) then
		-- if number of units to spawn is less than available positions - get the coef and decrease overall units number according to it - but no less than 1 unit in each category
	
		local coef = num / total_pos
		
		snipers_num = math.floor(snipers_num * coef)
		
		if (snipers_num < 1) then
			snipers_num = 1
		end
		
		soldiers_num = math.floor(soldiers_num * coef)
		
		if (soldiers_num < 1) then
			soldiers_num = 1
		end
		
		guards_num = math.floor(guards_num * coef)
		
		if (guards_num < 1) then
			guards_num = 1
		end
		
	end
	
	local force = CUR_MISSION.Forces[player]
	local units = deepcopy(SpawnUnits[force])
	local phase = "Phase_"..GAME_STAGE
	local thing_pre = ""
	local spawn_name = ""
	local phase_num = GAME_STAGE + 1
	local army_suffix = ""
	
	if (GAME_STAGE > 4) then
		phase = "Phase_4"
		phase_num = 5
	end
	
	log("spawnDefenders", "force:", force, "phase:", phase, phase_num)
	
	local entity = 
	{
		sysname = "",
		behavior = "squad_leader",
		behavior_arg = mode,
		specialization = "soldier",
		dialog = "",
		things = "",
		pose = "stand",
		power = 1
	}
	
--	if (mode == "attackers") then
--		entity.behavior_arg = "bandits"
--	end
	
	local getRandomUnit = function(list)
		-- returns a random unit from given list of units
		if not(isValid(list)) then
			log("spawnDefenders", "getRandomUnit->error")
			return nil
		end
		
		local size = service.getListSize(list)
		local res = ""
		local rnd = math.random(size)
		local counter = 1

		local get = function(index, value)
			if (counter == rnd) then
				res = value
			end
			counter = counter + 1
		end
		
		table.foreach(list, get)

		log("spawnDefenders", res)
		
		return res
	end
	
	log("spawnDefenders",Joints["pirate_island"]["port"].entrance)
	log("spawnDefenders", "BATTLE_DATA.Entrance",BATTLE_DATA.Entrance)
	log("spawnDefenders", "BATTLE_DATA.Attacker",BATTLE_DATA.Attacker)
        log("spawnDefenders", "BATTLE_DATA.AttackerSize",BATTLE_DATA.AttackerSize)
        log("spawnDefenders", "BATTLE_DATA.Sector",BATTLE_DATA.Sector)
        log("spawnDefenders", "BATTLE_DATA.Enabled",BATTLE_DATA.Enabled)

        if(BATTLE_DATA.Entrance == nil) then
	        BATTLE_DATA.Entrance = "west"
	end
	
	local setSpawnName = function(pos, num) --prefix, num)
		-- sets the random spawn name from available positions - skipping already taken
		local found = false
		
		if (mode == "attackers") then
			spawn_name = BATTLE_DATA.Entrance
			found = true
			return true
		end
		
		for count = 1, 500, 1 do
		--while (found == false) do
			local rnd = math.random(num) -- - 1
			
			if (rnd < 0) then
				rnd = 0
			end
			
			found = true
			spawn_name = pos[rnd] --prefix..tostring(rnd)
			
			local check = function(index, current_spawn)
				if (current_spawn == spawn_name) then
					found = false
				end
				return
			end
			
			table.foreach(CUR_MISSION.busy_spawns, check)
			if (found == true) then
				table.insert(CUR_MISSION.busy_spawns, spawn_name)
				return true
			end
		end
		--spawn_name = pos[math.random(num)]
		return false
	end	
	
	-- setting prefix for thing sets according to force
	
	if ((force == ARMY) or (force == REBELS)) then
		thing_pre = "army_l0"..tostring(phase_num)
		
		if ( math.random() > 0.75) then
			army_suffix = "_a"
		else
			army_suffix = "_b"
		end
	elseif ((force == MARAUDERS) or (force == PIRATS)) then
		thing_pre = "mar_l0"..tostring(phase_num)
	elseif (force == UN) then
		thing_pre = "un_l05"
		
		if ( math.random() > 0.75) then
			army_suffix = "_a"
		else
			army_suffix = "_b"
		end
	elseif (force == CORP) then
		thing_pre = "corp_l0"..tostring(phase_num)
	elseif (force == BUTSI) then
		thing_pre = "butsi_l0"..tostring(phase_num)
	end

	-- spawning leaders
	--
	if (leaders > 0) then
		for count = 1, leaders_num, 1 do
			entity.sysname = getRandomUnit(units.Leaders[phase])
			entity.things = thing_pre.."_officer"..army_suffix.."_01,"..thing_pre.."_officer"..army_suffix.."_02,"..thing_pre.."_officer"..army_suffix.."_03"
			--setSpawnName("leader_", leaders)
			if (setSpawnName(leader_pos, leaders)) then
				spawnEntity(player_to_spawn, spawn_name, entity, "_"..tostring(count))
				if (mode ~= "attackers") then
					MILITIA_DATA[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = player
				else
					BATTLE_DATA.AttackingUnits[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = false
				end
			else
				log("spawnDefenders", "Error on spawn Leaders - no free names!")
			end
		end
		
		log("spawnDefenders", "Leaders spawned")
	end
	
	entity.behavior = "squaddy"
	
	-- spawning soldiers
	if (soldiers > 0) then
		for count = 1, soldiers_num, 1 do
			entity.sysname = getRandomUnit(units.Soldiers[phase])
			entity.things = thing_pre.."_soldier"..army_suffix.."_01,"..thing_pre.."_soldier"..army_suffix.."_02,"..thing_pre.."_soldier"..army_suffix.."_03,"..thing_pre.."_soldier"..army_suffix.."_04,"..thing_pre.."_soldier"..army_suffix.."_05"
			--setSpawnName("soldier_", soldiers)
			if (setSpawnName(soldier_pos, soldiers)) then
				spawnEntity(player_to_spawn, spawn_name, entity, "_"..tostring(count))
				if (mode ~= "attackers") then
					MILITIA_DATA[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = player
				else
					BATTLE_DATA.AttackingUnits[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = false
				end
			else
				log("spawnDefenders", "Error on spawn Soldiers - no free names!")
			end
		end
		
		log("spawnDefenders", "Soldiers spawned")
	end

	entity.specialization = "guard"
	
	-- spawning guards
	if (guards > 0) then
		for count = 1, guards_num, 1 do
			entity.sysname = getRandomUnit(units.Guards[phase])
			entity.things =  thing_pre.."_heavy"..army_suffix.."_01,"..thing_pre.."_heavy"..army_suffix.."_02,"..thing_pre.."_heavy"..army_suffix.."_03"
			--setSpawnName("guard_", guards)
			if (setSpawnName(guard_pos, guards)) then
				spawnEntity(player_to_spawn, spawn_name, entity, "_"..tostring(count))
				if (mode ~= "attackers") then
					MILITIA_DATA[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = player
				else
					BATTLE_DATA.AttackingUnits[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = false
				end
			else
				log("spawnDefenders", "Error on spawn Guards - no free names!")
			end
		end
		
		log("spawnDefenders", "Guards spawned")
	end
	
	
	
	entity.specialization = "sniper"
	
	-- spawning snipers
	if (snipers > 0) then
		for count = 1, snipers_num, 1 do
			entity.sysname = getRandomUnit(units.Snipers[phase])
			entity.things = thing_pre.."_sniper"..army_suffix.."_01,"..thing_pre.."_sniper"..army_suffix.."_02"
			--setSpawnName("sniper_", snipers)
			if (setSpawnName(sniper_pos, snipers)) then
				spawnEntity(player_to_spawn, spawn_name, entity, "_"..tostring(count))
				if (mode ~= "attackers") then
					MILITIA_DATA[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = player
				else
					BATTLE_DATA.AttackingUnits[spawn_name.."_"..entity.sysname.."_"..tostring(count)] = false
				end
			else
				log("spawnDefenders", "Error on spawn Snipers - no free names!")
			end
		end
		
		log("spawnDefenders", "Snipers spawned")
	end
	
	return
end
--
function spawnMilitia()
	log("spawn_militia", "ENTRANCE")
	
	local sector = CUR_MISSION.Name
	
	if (BATTLE_DATA.Enabled == true) then
		if (not(isValid(sector)) or (BATTLE_DATA.Sector ~= sector)) then
			sector = BATTLE_DATA.Sector
		end
	end
	
	local mi = getMilitiaInfo(sector)
	
	local doit = function(slot, data)
		if ( (slot ~= "num") and (slot ~= "slots") and (data ~= nil) ) then
			if ( (isValid(data.num)) and (data.num > 0) and (isValid(data.mtype)) ) then
				log("spawn_militia", "> Slot:", slot)
				spawnDefenders(sector, data.mtype, data.num, "militia")
			end
		end
	end
	
	if (isValid(mi)) then
		if (isValid(mi.num)) then
			if (mi.num ~= 0) then
				table.foreach(mi, doit)
			end
		end
	end
	
	log("spawn_militia", "EXIT")
end
--
function sendMail(email_id, inbox_id, status, silent)

	log("!EMAIL", email_id )

	local vip = false
	
	if (Emails[email_id] == nil) then
		if (inbox_id == nil) then
			inbox_id = INBOX
		end
		
		if (status == nil) then
			status = UNREAD
		end
		
	else
		inbox_id = Emails[email_id].inbox
		status = Emails[email_id].status
		vip = Emails[email_id].vip
	end
	
	if (silent == nil) then
		silent = false
	end
	
	Emails[email_id].sent = true
	sendEmail(email_id, inbox_id, status)

	if (silent == false) then
		sendMessage(NEW_EMAIL, NEW_EMAIL)
	end
	
	if (vip == true) then
		stopTime()
	end
end

function addEntry(entry_id, silent)
	addJournalEntry(entry_id)
	
	if (silent == false) then
		sendMessage(NEW_ENTRY, NEW_ENTRY)
	end
end

function massMail(emails_list)
-- emails_list = { email1_id = {inbox_id = INBOX|SPAM, status = READ|UNREAD, silent = bool} }
	local send = function(index,value)
		sendMail(index, value.inbox_id, value.status, value.silent)
	end
	table.foreach(emails_list, send)
end

function massEntry(entries_list)
-- entries_list = { entry1_id = bool silent, entry2_id = bool silent}
	local add = function(index,value)
		addEntry(index, value)
	end
	table.foreach(entries_list, add)
end

function setMoney(value)
	deductMoney(getMoney())
	addMoney(value)
end

function setGVAR(gvar, gval)
	local log_id = C_TOOLS
	setVariable(gvar, tostring(gval))
	GVARS[gvar] = gval
	log(log_id, gvar, " set to ", gval)
	
	if ((gvar == "CURRENT_ALLY") or (gvar == "CURR_ALLY")) then
		currentAllyTransform(gval)
	end
end

function getGVAR(gvar)
	local log_id = C_TOOLS
	local gv = tonumber(getVariable(gvar))
	local gval = GVARS[gvar]
	log(log_id, "getting ", gvar, ",  it is ", gv, " in logic and ", gval, " in lua")

	if (gvar == "isRT") then
		return tonumber(isGameInRT())
	end

	if (gv ~= gval) then
		GVARS[gvar] = gv
	end

	return gv
end

dissmissedMercs = {}

function hireMerc(merc, equip)
	local log_id = C_HIRE
	
	hirePerson(merc, equip)
	
	addJournalEntry("hire_"..merc)
	sendMessage("hire_"..merc, NEW_ENTRY)
	
	log(log_id, ":", merc)
	
	updateMorale(getHiredMercs(true), MoraleBonus.TINY, merc.." hired")
	
	HEAL_PASSED[merc] = -1
	Mercs[merc].hired = true
	
	setPersonParameter(merc, "MORALE", 50)
	
	Mercs[merc].salary = getPersonParameter(merc, "SALARY")
	
	getHiredMercs(true)
	emo2000(merc, "hired")

	dissmissedMercs[merc] = nil
	
	return
end

function hireMercToSquad(merc, equip)
	local log_id = C_HIRE
	local result = hirePersonToSquad(merc, equip)
	
	log(log_id, "   :", merc)
	
	if (result == false) then
		log(log_id, " ")
		return false
	end
	
	log(log_id, ":", merc)
	
	setPersonParameter(merc, "MORALE", 50)

	local human = dissmissedMercs[merc]
	if(isValid(human)) then
		local doMercCopy = function(index,data)
			if(index~="id") then
				setPersonParameter(merc, index, data)
			end
		end

		table.foreach(human,doMercCopy)
		dissmissedMercs[merc] = nil
	end

	Mercs[merc].salary = getPersonParameter(merc, "SALARY")
	
	addJournalEntry("hire_"..merc)
	sendMessage("hire_"..merc, NEW_ENTRY)
	
	updateMorale(getHiredMercs(true), MoraleBonus.TINY, merc.." hired")
	
	HEAL_PASSED[merc] = -1
	Mercs[merc].hired = true
	
	getHiredMercs(true)
	emo2000(merc, "hired")
	
	return true
end

function dismissMerc(merc, reason)
	local log_id = C_DISMISS
	local deposit = getPersonParameter(merc, "DEPOSIT")
	
	addJournalEntry("dismiss_"..merc)
	sendMessage("dismiss_"..merc, NEW_ENTRY)
	addMoney(deposit)
	
	HEAL_PASSED[merc] = -1
	Mercs[merc].hired = false

	local human = 
	{
		id = merc,
		SALARY = getPersonParameter(merc, "SALARY" ),
		HEALTH = getPersonParameter(merc, "DURABILITYMAX" ),
		DURABILITYMAX = getPersonParameter(merc, "DURABILITYMAX" ),
		LEVEL = getPersonParameter(merc, "LEVEL" ),
		DEXTERITY = getPersonParameter(merc, "DEXTERITY"),
		AGILITY = getPersonParameter(merc, "AGILITY" ),
		STRENGTH = getPersonParameter(merc, "STRENGTH" ),
		WISDOM = getPersonParameter(merc, "WISDOM" ),
		LEADERSHIP = getPersonParameter(merc, "LEADERSHIP" ),
		MARKSMANSHIP = getPersonParameter(merc, "MARKSMANSHIP" ),
		MECHANICAL = getPersonParameter(merc, "MECHANICAL" ),
		EXPLOSIVES = getPersonParameter(merc, "EXPLOSIVES" ),
		MEDICAL = getPersonParameter(merc, "MEDICAL" ),
		BANDAGED = 0,
	}
	dissmissedMercs[merc] = deepcopy(human)
	setPersonParameter(merc,"HEALTH",human.HEALTH)

	getHiredMercs(true)
	
	showComments(merc, merc..reason, table_values.corner, 1, 0, 5)
	
	if ( reason == "_hire_refuse_lazy" ) then
		changeBadReputation(5)
		updateMorale(HIRED_MERCS, MoralePenalty.SMALL, merc.." leaves due to no money")
	else
		changeBadReputation(2)
	end
	
	dismissPerson(merc)

	log(log_id, merc, "is dismissed")
	
	if ( isValid(CUR_MISSION.Name) ) then
		if ( checkIfMercIsOnList(merc) == true ) then
			disappearHuman(merc)
		end
	end
	
	for index, name in pairs(CUR_MISSION.Mercs) do
		if (name == merc) then
			table.remove(CUR_MISSION.Mercs, index)
			break
		end
	end
	
	return
end

function setPosition(squad, position)
	INNER_POSITION_CALL = true
	if ((squad == nil) or (squad == 0)) then
		return
	end
	local squad_str = "squad"..squad
	log("pos_changed", "New Position for squad", squad, "is", position)
	SQUADS_POSITIONS[squad_str] = position
	setCurrentMission(squad, position)
	return
end

function setDestination(squad, destination)
	INNER_DESTINATION_CALL = true
	if ((squad == nil) or (squad == 0)) then
		return
	end
	log("des_changed", "New Destination for squad", squad, "is", destination)
	local squad_str = "squad"..squad
	SQUADS_DESTINATIONS[squad_str] = destination
	setDestinationMission(squad, destination)
	return
end

function enterSector(sector, save)
	if(not CampaignScript.missionAlreadyStarted) then
		initAIConst()
		if not(isValid(save)) then
			save = true
		end
		CUR_MISSION.Name = sector
		Sectors[sector].onLoad()
		startMission(sector,"", save)
		CampaignScript.missionAlreadyStarted = true
	end
end

function set_order(who, order_type, order_opt)
--	log("_zzzzz", "set_order  is called")
	if "patrol" == order_type then
--		log("_zzzzz", "__>set_order	", "	who: ", who, "	order_type: ", order_type, "	order_opt: ", order_opt)
		Humans[who].behavior = "patrol"
		Humans[who].patrol_routine = order_opt
	end
	if "assault" == order_type then
		Humans[who].patrol_routine = ""
		Humans[who].behavior = "assault"
	end	
	if "solider" == order_type then
		Humans[who].patrol_routine = ""
		Humans[who].behavior = "solider"
	end		
end